;;; zorknib.lisp
;;;
;;; zork nibimage tools
;;;

;; SECTOR TRANSLATE TABLE--DIFFERENT FROM DOS 3.3

(defconstant +zork-sector-translate+
#(#x0 #x4 #x8 #xC      
  #x1 #x5 #x9 #xD
  #x2 #x6 #xA #xE
  #x3 #x7 #xB #xF))

(defconstant +zork-data-prolog+ #(#xd5 #xaa #xbc))

#| 
however, on the image I have, it seems that
(setf *t25s1* (track-sector *znib* 25 1 :data-prolog #(213 170 173) 
                              :data-epilog #(222 170 237)      
                              :sector-translate +zork-sector-translate+))
works on track 25... 
|#

(defun zork-track-sector (image track sector)
  (if (zerop track)
    (track-sector image track sector)
    (track-sector image track sector :sector-translate +zork-sector-translate+
                  :data-prolog +zork-data-prolog+)))

(defun read-zork-rwts (zorknib &optional (sector-count 10))
  (let ((rwts-array (make-array (* sector-count 256) :element-type
                                '(unsigned-byte 8))))
    (dotimes (s sector-count rwts-array)
      (let ((sec (zork-track-sector zorknib 0 s)))
        (dotimes (i 256)
          (setf (aref rwts-array (+ i (* s 256))) (aref sec i)))))))

(defun read-zork-interpreter (zorknib &optional (sector-count 26))
  (let ((zil-array (make-array (* sector-count 256) :element-type
                               '(unsigned-byte 8))))
    (dotimes (s sector-count zil-array)
      (multiple-value-bind (trk sec) 
                           (floor s 16)
        (let ((sec-data (zork-track-sector zorknib (1+ trk) sec)))
          (dotimes (i 256)
            (setf (aref zil-array (+ i (* s 256))) (aref sec-data i))))))))

(defun read-zork-program (zorknib sector-count)
  (let ((zil-prog-array (make-array (* sector-count 256) :element-type
                                    '(unsigned-byte 8))))
    (dotimes (s sector-count zil-prog-array)
      (multiple-value-bind (trk sec)
                           (floor s 16)
        (let ((sec-data (zork-track-sector zorknib (+ 3 trk) sec)))
          (dotimes (i 256)
            (setf (aref zil-prog-array (+ i (* s 256))) (aref sec-data i))))))))
  